"use client"

import { useState } from "react"
import { stages } from "@/lib/flowchart-data"
import { StageCard } from "@/components/stage-card"
import { FlowConnector } from "@/components/flow-connector"
import { FlowSummary } from "@/components/flow-summary"
import { CheckCircle2, Shield, Banknote, FileCheck } from "lucide-react"

export function Flowchart() {
  const [activeStage, setActiveStage] = useState<number | null>(null)

  return (
    <div className="min-h-screen bg-background">
      {/* Header */}
      <header className="border-b border-border bg-card/50 backdrop-blur-sm sticky top-0 z-50">
        <div className="max-w-7xl mx-auto px-4 py-6">
          <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
              <h1 className="text-2xl md:text-3xl font-bold text-foreground text-balance">
                National Centralized Academic Admission System
              </h1>
              <p className="text-muted-foreground mt-1">
                Complete Workflow Diagram
              </p>
            </div>
            <div className="flex items-center gap-2 text-sm text-muted-foreground">
              <span className="px-3 py-1 bg-accent/20 text-accent rounded-full font-medium">
                {stages.length} Stages
              </span>
            </div>
          </div>
        </div>
      </header>

      <main className="max-w-7xl mx-auto px-4 py-8">
        {/* Key Principles */}
        <section className="mb-12">
          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <div className="flex items-center gap-3 p-4 rounded-lg bg-card border border-border">
              <div className="p-2 rounded-lg bg-accent/20">
                <CheckCircle2 className="w-5 h-5 text-accent" />
              </div>
              <div>
                <p className="font-medium text-foreground text-sm">Flexible</p>
                <p className="text-xs text-muted-foreground">Multiple pathways supported</p>
              </div>
            </div>
            <div className="flex items-center gap-3 p-4 rounded-lg bg-card border border-border">
              <div className="p-2 rounded-lg bg-primary/20">
                <Shield className="w-5 h-5 text-primary" />
              </div>
              <div>
                <p className="font-medium text-foreground text-sm">Secure</p>
                <p className="text-xs text-muted-foreground">NIN & payment verification</p>
              </div>
            </div>
            <div className="flex items-center gap-3 p-4 rounded-lg bg-card border border-border">
              <div className="p-2 rounded-lg bg-chart-3/20">
                <Banknote className="w-5 h-5 text-chart-3" />
              </div>
              <div>
                <p className="font-medium text-foreground text-sm">Sustainable</p>
                <p className="text-xs text-muted-foreground">Payment-gated access</p>
              </div>
            </div>
            <div className="flex items-center gap-3 p-4 rounded-lg bg-card border border-border">
              <div className="p-2 rounded-lg bg-chart-5/20">
                <FileCheck className="w-5 h-5 text-chart-5" />
              </div>
              <div>
                <p className="font-medium text-foreground text-sm">Inclusive</p>
                <p className="text-xs text-muted-foreground">WAEC is optional</p>
              </div>
            </div>
          </div>
        </section>

        {/* Flow Summary */}
        <section className="mb-12">
          <FlowSummary />
        </section>

        {/* Flowchart Stages */}
        <section>
          <h2 className="text-xl font-semibold text-foreground mb-6">Detailed Workflow Stages</h2>
          
          <div className="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6">
            {stages.map((stage, idx) => (
              <div key={stage.id} className="relative">
                <StageCard
                  stage={stage}
                  isActive={activeStage === stage.id}
                  onClick={() => setActiveStage(activeStage === stage.id ? null : stage.id)}
                />
                
                {/* Mobile Flow Connector */}
                {idx < stages.length - 1 && (
                  <div className="lg:hidden">
                    <FlowConnector />
                  </div>
                )}
              </div>
            ))}
          </div>
        </section>

        {/* Legend */}
        <section className="mt-12">
          <div className="bg-card border border-border rounded-lg p-6">
            <h3 className="text-lg font-semibold text-foreground mb-4">Stage Legend</h3>
            <div className="grid grid-cols-2 md:grid-cols-5 gap-4">
              <div className="flex items-center gap-2">
                <div className="w-4 h-4 rounded bg-primary" />
                <span className="text-sm text-muted-foreground">Core Process</span>
              </div>
              <div className="flex items-center gap-2">
                <div className="w-4 h-4 rounded bg-accent" />
                <span className="text-sm text-muted-foreground">Verification</span>
              </div>
              <div className="flex items-center gap-2">
                <div className="w-4 h-4 rounded bg-chart-3" />
                <span className="text-sm text-muted-foreground">Assessment</span>
              </div>
              <div className="flex items-center gap-2">
                <div className="w-4 h-4 rounded bg-chart-5" />
                <span className="text-sm text-muted-foreground">Review</span>
              </div>
              <div className="flex items-center gap-2">
                <div className="w-4 h-4 rounded bg-destructive" />
                <span className="text-sm text-muted-foreground">Important Note</span>
              </div>
            </div>
          </div>
        </section>

        {/* Final Assessment */}
        <section className="mt-12">
          <div className="bg-accent/10 border border-accent/30 rounded-lg p-6">
            <h3 className="text-lg font-semibold text-foreground mb-4">Final Assessment</h3>
            <p className="text-muted-foreground mb-4">
              This workflow design represents a complete national admission and identity ecosystem that is:
            </p>
            <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
              <div className="text-center p-4 bg-card rounded-lg">
                <p className="text-2xl font-bold text-accent">100%</p>
                <p className="text-sm text-muted-foreground">Financially Sustainable</p>
              </div>
              <div className="text-center p-4 bg-card rounded-lg">
                <p className="text-2xl font-bold text-primary">100%</p>
                <p className="text-sm text-muted-foreground">Abuse-Resistant</p>
              </div>
              <div className="text-center p-4 bg-card rounded-lg">
                <p className="text-2xl font-bold text-chart-3">100%</p>
                <p className="text-sm text-muted-foreground">Policy-Defensible</p>
              </div>
              <div className="text-center p-4 bg-card rounded-lg">
                <p className="text-2xl font-bold text-chart-5">100%</p>
                <p className="text-sm text-muted-foreground">Ready for Rollout</p>
              </div>
            </div>
          </div>
        </section>
      </main>

      {/* Footer */}
      <footer className="border-t border-border mt-12">
        <div className="max-w-7xl mx-auto px-4 py-6">
          <p className="text-center text-sm text-muted-foreground">
            National Centralized Academic Admission System Workflow
          </p>
        </div>
      </footer>
    </div>
  )
}
