import {
  CreditCard,
  UserPlus,
  ShieldCheck,
  FileText,
  CheckCircle,
  ListChecks,
  Building2,
  Users,
  Award,
  Mail,
  Wallet,
  BarChart3,
  Settings,
} from "lucide-react"
import type { LucideIcon } from "lucide-react"

export interface FlowchartStage {
  id: number
  title: string
  shortTitle: string
  icon: LucideIcon
  description: string
  steps: string[]
  output: string[]
  keyNote?: string
  color: "blue" | "green" | "amber" | "teal" | "rose"
}

export const stages: FlowchartStage[] = [
  {
    id: 0,
    title: "National System Preparation",
    shortTitle: "System Setup",
    icon: Settings,
    description: "Before applications open - happens once per admission cycle",
    steps: [
      "Ministry registers institutions & colleges",
      "Registers programs & entry requirements",
      "Sets quotas & policies",
      "Registers supported examination bodies (WAEC, GCE, IB, TVET, Foreign)",
      "Defines application fees by category",
    ],
    output: ["Admission cycle configured"],
    color: "blue",
  },
  {
    id: 1,
    title: "Application Fee Payment",
    shortTitle: "Fee Payment",
    icon: CreditCard,
    description: "Entry gate - No payment = no account",
    steps: [
      "Applicant chooses application category (Undergraduate/Postgraduate, Local/Foreign, Transfer/Mature)",
      "System displays applicable application fee",
      "Applicant pays via Mobile Money, Visa/Mastercard, Bank transfer, or Authorized agents",
      "Payment verified automatically",
      "Unique Payment Reference ID generated",
    ],
    output: ["Verified payment", "Payment Reference ID issued"],
    keyNote: "No payment = no account",
    color: "green",
  },
  {
    id: 2,
    title: "Account Creation",
    shortTitle: "Account Creation",
    icon: UserPlus,
    description: "National Portal account linked to payment",
    steps: [
      "Applicant creates account using Payment Reference ID",
      "Enter email or phone number",
      "OTP verification",
      "Password setup",
      "System links payment to account (One payment = one application cycle)",
    ],
    output: ["National applicant account created", "Abuse and duplicate applications prevented"],
    color: "blue",
  },
  {
    id: 3,
    title: "Identity Verification",
    shortTitle: "Identity Check",
    icon: ShieldCheck,
    description: "NIN preferred, alternatives available",
    steps: [
      "Applicant selects identity method (NIN preferred, Passport, Manual verification)",
      "If NIN provided: System calls NCRA API, biodata fetched (name, DOB, gender, nationality, photo)",
      "Biodata auto-filled & locked, applicant reviews and confirms",
      "If no NIN: Applicant enters biodata manually, uploads ID document, application flagged for verification",
    ],
    output: ["Verified or conditionally verified identity"],
    color: "teal",
  },
  {
    id: 4,
    title: "Academic Qualification",
    shortTitle: "Qualifications",
    icon: FileText,
    description: "WAEC optional - multiple exam bodies supported",
    steps: [
      "Applicant selects examination body (WAEC, GCE/Cambridge, TVET/NVQ, IB, Foreign/Other)",
      "API-based verification (e.g. WAEC): results fetched digitally",
      "Document-based: certificates uploaded for review",
    ],
    output: ["Verified or pending academic record", "WAEC remains optional"],
    color: "amber",
  },
  {
    id: 5,
    title: "Eligibility Assessment",
    shortTitle: "Eligibility",
    icon: CheckCircle,
    description: "Transparent evaluation of applicant qualifications",
    steps: [
      "System evaluates eligibility against subject requirements",
      "Checks minimum grades",
      "Applies program-specific rules",
    ],
    output: ["Eligible programs listed", "Conditionally eligible programs listed", "Not eligible (with reasons)"],
    color: "green",
  },
  {
    id: 6,
    title: "Program & Institution Selection",
    shortTitle: "Program Selection",
    icon: ListChecks,
    description: "Ranked choices from eligible programs only",
    steps: [
      "Only eligible programs displayed to applicant",
      "Applicant selects and ranks choices (1st, 2nd, 3rd...)",
      "Applicant submits application",
    ],
    output: ["Application enters national pool"],
    color: "blue",
  },
  {
    id: 7,
    title: "Central Screening",
    shortTitle: "Central Review",
    icon: Building2,
    description: "National system performs verification checks",
    steps: [
      "Automated checks performed",
      "Manual verification where required",
      "Application status set (Approved, Pending clarification, Rejected)",
    ],
    output: ["Clean, approved applicant pool"],
    color: "teal",
  },
  {
    id: 8,
    title: "Institution Review",
    shortTitle: "Institution Review",
    icon: Users,
    description: "Institutions assess but do not admit",
    steps: [
      "Approved applications pushed to institutions",
      "Program-specific lists with verified documents",
      "Institutions conduct internal assessments (interviews, aptitude tests, departmental screening)",
      "Institutions submit recommendations (Recommended, Not recommended, Conditional)",
    ],
    output: ["Institutional feedback returned centrally"],
    keyNote: "Institutions recommend - they do not admit",
    color: "amber",
  },
  {
    id: 9,
    title: "Centralized Placement",
    shortTitle: "Placement",
    icon: Award,
    description: "Final admission decisions made centrally",
    steps: [
      "Central placement engine runs",
      "Applies applicant ranking",
      "Considers institutional recommendations",
      "Enforces quotas & national policies",
    ],
    output: ["Nationally approved admissions"],
    color: "green",
  },
  {
    id: 10,
    title: "Offer Release & Acceptance",
    shortTitle: "Offer & Accept",
    icon: Mail,
    description: "Admission offers with automatic institution account creation",
    steps: [
      "Admission offers issued via national portal, SMS/Email",
      "Applicant responds (Accept or Decline)",
      "Deadline enforced",
      "On acceptance: National system pushes data to institution",
      "Institution auto-creates Pre-Enrollment Student Account",
      "Institution Student ID generated",
    ],
    output: ["Accepted offers confirmed", "Applicant has institution account", "No manual registration required"],
    color: "blue",
  },
  {
    id: 11,
    title: "Payment & Enrollment",
    shortTitle: "Enrollment",
    icon: Wallet,
    description: "Final enrollment completion",
    steps: [
      "Applicant pays acceptance fee and tuition deposit",
      "Payment verified",
      "Account upgraded from Pre-Enrolled to Fully Enrolled",
      "Student gains full institutional access (course registration, LMS, library, student email)",
    ],
    output: ["Fully enrolled student"],
    color: "green",
  },
  {
    id: 12,
    title: "Reporting & Analytics",
    shortTitle: "Reports",
    icon: BarChart3,
    description: "National planning & accountability data",
    steps: [
      "Application numbers tracked",
      "Revenue from application fees",
      "Institutional intake monitored",
      "Regional & gender distribution analyzed",
      "Exam body statistics compiled",
    ],
    output: ["National planning & accountability data"],
    color: "teal",
  },
]

export const flowSummary = [
  "Application Fee Payment",
  "Account Creation",
  "Identity Verification (NIN / ID)",
  "Academic Qualification (WAEC or Others)",
  "Eligibility Assessment",
  "Program Selection",
  "Central Screening",
  "Institution Review",
  "Central Placement",
  "Offer & Acceptance",
  "Auto Institution Account Creation",
  "Enrollment Payment",
  "Full Enrollment",
]
